#!/bin/bash

export LD_LIBRARY_PATH=/home/pi/despi
# ALSA equal plugin needs for some reason at least HOME set, which systemd does NOT set by default
# this causes an "operation not permitted" on open equal devices
export USER=root
export HOME=/root

# start script for tiltaudio

# add user in gpio group for wiring pi
# usermod -a -G gpio pi
# remount boot and make it writeable for pi user
# umount /boot
# mount -o rw,fmask=0000,dmask=0000 /dev/mmcblk0p1 /boot

# function to add timestamp to log file
adddate() {
	while IFS= read -r line; do
		echo "$(date +'%Y-%m-%d %T.%3N') DEBUG $line"
	done
}

# usb stick support: detect if this path exists, if so use it as base path for update, soundset logging
BASEPATH=/boot
if [ -d /media/usb1/data ]; then
	BASEPATH=/media/usb1
fi
if [ -d /media/usb2/data ]; then
	BASEPATH=/media/usb2
fi
if [ -b /dev/sda ]; then
	BASEPATH=/media/usb1
fi

# log rotate
mv $BASEPATH/data/raspin2.log $BASEPATH/data/raspin3.log 2>/dev/null
mv $BASEPATH/data/raspin1.log $BASEPATH/data/raspin2.log 2>/dev/null
mv $BASEPATH/data/raspin.log $BASEPATH/data/raspin1.log 2>/dev/null

echo "BASEPATH is $BASEPATH" | adddate >>$BASEPATH/data/raspin.log

if [ -f $BASEPATH/data/options.txt ]; then
	echo "Found options.txt" | adddate >>$BASEPATH/data/raspin.log
	OPTIONS=$(cat $BASEPATH/data/options.txt)
fi

DESPI=despi

# check on /usr/lib/arm-linux-gnueabihf/libmicrohttpd*
for f in /usr/lib/arm-linux-gnueabihf/libmicrohttpd*; do
	DESPI=despi2
	OPTIONS="-H $OPTIONS"
	break
done

if [ -f /home/pi/despi/asound.conf ]; then
	echo "Found new asound.conf -> copying" | adddate >>$BASEPATH/data/raspin.log
	cp -f /home/pi/despi/asound.conf /etc
	mv /home/pi/despi/asound.conf /home/pi/despi/asound.conf.copied
fi

if [ -d /home/pi/despi/dsp ] && [ ! -d $BASEPATH/data/dsp ]; then
	echo "Found new standard dsp conf / firmware copy to data" | adddate >>$BASEPATH/data/raspin.log
	cp -f -r /home/pi/despi/dsp/ $BASEPATH/data/.
	mv /home/pi/despi/dsp /home/pi/despi/dsp.copied
fi

# make SDL use this audio device (in this case the USB sound card)
if [ -f $BASEPATH/data/use-usb.txt ]; then
	echo "Found use-usb.txt setting AUDIODEV=hw:2,0" | adddate >>$BASEPATH/data/raspin.log
	export AUDIODEV=hw:2,0
fi

# update handling
for f in $BASEPATH/update/update*.zip; do
	if [ -f $f ]; then
		echo "update found: $f" | adddate >>$BASEPATH/data/raspin.log
		unzip -o $f -d /home/pi | adddate >>$BASEPATH/data/raspin.log
		echo "rename $f to $f.done" | adddate >>$BASEPATH/data/raspin.log
		mv -f $f $f.done
		sync
		echo "reloading start-script" | adddate >>$BASEPATH/data/raspin.log
		/home/pi/despi/tiltaudio.sh
		exit 0
	fi
	# break after first found
	break
done

export LUA_PATH=$BASEPATH/data/lua/?.lua
export LUA_CPATH=$BASEPATH/data/lua/?.so

# remove cores older than a day
find $BASEPATH/data/ -type f -mtime +1 -name 'core-*' -exec rm -f '{}' \;
# to avoid filling uo root files system
mv /home/pi/core-* $BASEPATH/data/ 2>/dev/null
# alert if cores are found
for f in $BASEPATH/data/core-*; do
	if [ -f $f ]; then
		echo "CORE found $f" | adddate >>$BASEPATH/data/raspin.log
	fi
done
# reconfigure where to write core files
sysctl -q kernel.core_pattern=/home/pi/core-%e-%s-%t
# enable writing core files
ulimit -c unlimited

# default DSP firmware
DSPXML=/home/pi/despi/dsp/tiltaudio.xml
# look for a custom firmware
if [ -f $BASEPATH/data/dsp/tiltaudio.xml ]; then
	echo "Detected custom DSP firmware on SD card" | adddate >>$BASEPATH/data/raspin.log
	DSPXML="$BASEPATH/data/dsp/tiltaudio.xml"
fi

/home/pi/despi/sigma_loader $DSPXML >>$BASEPATH/data/raspin.log
if [ "$?" -eq 0 ]; then
	echo "DSP firmware uploaded" | adddate >>$BASEPATH/data/raspin.log
	export ADAU1701=TRUE
	dtoverlay -v adau1701-i2s 2>&1 >/dev/null | adddate >>$BASEPATH/data/raspin.log
	OPTIONS="-X $DSPXML $OPTIONS"
else
	echo "DSP not found, loading overlay hifiberry" | adddate >>$BASEPATH/data/raspin.log
	dtoverlay -v hifiberry-dac 2>&1 >/dev/null | adddate >>$BASEPATH/data/raspin.log
fi

cd /home/pi/despi

openocd -f test.cfg 2>&1 | adddate >>$BASEPATH/data/raspin.log
if [ "$?" -eq 0 ]; then
	echo "STM32F4 detected on SPI port, trigger update check" | adddate >>$BASEPATH/data/raspin.log
	/home/pi/despi/update_check /home/pi/despi >>$BASEPATH/data/raspin.log
fi

/home/pi/despi/$DESPI $OPTIONS -f $BASEPATH/data/raspin.log $BASEPATH/data/sound
