/*
 * File:           C:\Users\stefa\git\RasPinSound\dsp\tilt!audio_I2S-200_IC_1_PARAM.h
 *
 * Created:        Sunday, October 25, 2020 9:05:54 AM
 * Description:    tilt!audio_I2S-200:IC 1 parameter RAM definitions.
 *
 * This software is distributed in the hope that it will be useful,
 * but is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * This software may only be used to program products purchased from
 * Analog Devices for incorporation by you into audio products that
 * are intended for resale to audio product end users. This software
 * may not be distributed whole or in any part to third parties.
 *
 * Copyright ©2020 Analog Devices, Inc. All rights reserved.
 */
#ifndef __TILTAUDIO_I2S_200_IC_1_PARAM_H__
#define __TILTAUDIO_I2S_200_IC_1_PARAM_H__


/* Module pulsed - Pulse with dynamic duty cycle*/
#define MOD_PULSED_COUNT                               4
#define MOD_PULSED_DEVICE                              "IC1"
#define MOD_PULSED_ALG0_FREQ_STEP_ADDR                 0
#define MOD_PULSED_ALG0_FREQ_STEP_FIXPT                0x00000DA7
#define MOD_PULSED_ALG0_FREQ_STEP_VALUE                SIGMASTUDIOTYPE_FIXPOINT_CONVERT(0.000416666666666667)
#define MOD_PULSED_ALG0_FREQ_STEP_TYPE                 SIGMASTUDIOTYPE_FIXPOINT
#define MOD_PULSED_ALG0_TH_ADDR                        1
#define MOD_PULSED_ALG0_TH_FIXPT                       0x00400000
#define MOD_PULSED_ALG0_TH_VALUE                       SIGMASTUDIOTYPE_FIXPOINT_CONVERT(0.5)
#define MOD_PULSED_ALG0_TH_TYPE                        SIGMASTUDIOTYPE_FIXPOINT
#define MOD_PULSED_ALG0_ON_ADDR                        2
#define MOD_PULSED_ALG0_ON_FIXPT                       0x00800000
#define MOD_PULSED_ALG0_ON_VALUE                       SIGMASTUDIOTYPE_FIXPOINT_CONVERT(1)
#define MOD_PULSED_ALG0_ON_TYPE                        SIGMASTUDIOTYPE_FIXPOINT
#define MOD_PULSED_ALG0_ISROUNDED_ADDR                 3
#define MOD_PULSED_ALG0_ISROUNDED_FIXPT                0x00000000
#define MOD_PULSED_ALG0_ISROUNDED_VALUE                SIGMASTUDIOTYPE_FIXPOINT_CONVERT(0)
#define MOD_PULSED_ALG0_ISROUNDED_TYPE                 SIGMASTUDIOTYPE_FIXPOINT

/* Module pulsed_2 - Pulse with dynamic duty cycle*/
#define MOD_PULSED_2_COUNT                             4
#define MOD_PULSED_2_DEVICE                            "IC1"
#define MOD_PULSED_2_ALG0_FREQ_STEP_ADDR               4
#define MOD_PULSED_2_ALG0_FREQ_STEP_FIXPT              0x00000057
#define MOD_PULSED_2_ALG0_FREQ_STEP_VALUE              SIGMASTUDIOTYPE_FIXPOINT_CONVERT(1.04166666666667E-05)
#define MOD_PULSED_2_ALG0_FREQ_STEP_TYPE               SIGMASTUDIOTYPE_FIXPOINT
#define MOD_PULSED_2_ALG0_TH_ADDR                      5
#define MOD_PULSED_2_ALG0_TH_FIXPT                     0x00400000
#define MOD_PULSED_2_ALG0_TH_VALUE                     SIGMASTUDIOTYPE_FIXPOINT_CONVERT(0.5)
#define MOD_PULSED_2_ALG0_TH_TYPE                      SIGMASTUDIOTYPE_FIXPOINT
#define MOD_PULSED_2_ALG0_ON_ADDR                      6
#define MOD_PULSED_2_ALG0_ON_FIXPT                     0x00800000
#define MOD_PULSED_2_ALG0_ON_VALUE                     SIGMASTUDIOTYPE_FIXPOINT_CONVERT(1)
#define MOD_PULSED_2_ALG0_ON_TYPE                      SIGMASTUDIOTYPE_FIXPOINT
#define MOD_PULSED_2_ALG0_ISROUNDED_ADDR               7
#define MOD_PULSED_2_ALG0_ISROUNDED_FIXPT              0x00000000
#define MOD_PULSED_2_ALG0_ISROUNDED_VALUE              SIGMASTUDIOTYPE_FIXPOINT_CONVERT(0)
#define MOD_PULSED_2_ALG0_ISROUNDED_TYPE               SIGMASTUDIOTYPE_FIXPOINT

/* Module DCB1 - DC Blocking*/
#define MOD_DCB1_COUNT                                 1
#define MOD_DCB1_DEVICE                                "IC1"
#define MOD_DCB1_DCBLOCKALGDOUBLEPREC1POLE_ADDR        8
#define MOD_DCB1_DCBLOCKALGDOUBLEPREC1POLE_FIXPT       0x007FFCB9
#define MOD_DCB1_DCBLOCKALGDOUBLEPREC1POLE_VALUE       SIGMASTUDIOTYPE_FIXPOINT_CONVERT(0.9999)
#define MOD_DCB1_DCBLOCKALGDOUBLEPREC1POLE_TYPE        SIGMASTUDIOTYPE_FIXPOINT

/* Module DCB2 - DC Blocking*/
#define MOD_DCB2_COUNT                                 1
#define MOD_DCB2_DEVICE                                "IC1"
#define MOD_DCB2_DCBLOCKALGDOUBLEPREC2POLE_ADDR        9
#define MOD_DCB2_DCBLOCKALGDOUBLEPREC2POLE_FIXPT       0x007FFCB9
#define MOD_DCB2_DCBLOCKALGDOUBLEPREC2POLE_VALUE       SIGMASTUDIOTYPE_FIXPOINT_CONVERT(0.9999)
#define MOD_DCB2_DCBLOCKALGDOUBLEPREC2POLE_TYPE        SIGMASTUDIOTYPE_FIXPOINT

/* Module NFilter1 - Nth Order Filter*/
#define MOD_NFILTER1_COUNT                             10
#define MOD_NFILTER1_DEVICE                            "IC1"
#define MOD_NFILTER1_ALG0_STAGE2_NTHORDERDOUBLE21_0B_1_ADDR 10
#define MOD_NFILTER1_ALG0_STAGE2_NTHORDERDOUBLE21_0B_1_FIXPT 0x007E9E11
#define MOD_NFILTER1_ALG0_STAGE2_NTHORDERDOUBLE21_0B_1_VALUE SIGMASTUDIOTYPE_FIXPOINT_CONVERT(0.989198913482263)
#define MOD_NFILTER1_ALG0_STAGE2_NTHORDERDOUBLE21_0B_1_TYPE SIGMASTUDIOTYPE_FIXPOINT
#define MOD_NFILTER1_ALG0_STAGE2_NTHORDERDOUBLE21_1B_1_ADDR 11
#define MOD_NFILTER1_ALG0_STAGE2_NTHORDERDOUBLE21_1B_1_FIXPT 0xFF02C3DD
#define MOD_NFILTER1_ALG0_STAGE2_NTHORDERDOUBLE21_1B_1_VALUE SIGMASTUDIOTYPE_FIXPOINT_CONVERT(-1.97839782696453)
#define MOD_NFILTER1_ALG0_STAGE2_NTHORDERDOUBLE21_1B_1_TYPE SIGMASTUDIOTYPE_FIXPOINT
#define MOD_NFILTER1_ALG0_STAGE2_NTHORDERDOUBLE21_2B_1_ADDR 12
#define MOD_NFILTER1_ALG0_STAGE2_NTHORDERDOUBLE21_2B_1_FIXPT 0x007E9E11
#define MOD_NFILTER1_ALG0_STAGE2_NTHORDERDOUBLE21_2B_1_VALUE SIGMASTUDIOTYPE_FIXPOINT_CONVERT(0.989198913482263)
#define MOD_NFILTER1_ALG0_STAGE2_NTHORDERDOUBLE21_2B_1_TYPE SIGMASTUDIOTYPE_FIXPOINT
#define MOD_NFILTER1_ALG0_STAGE2_NTHORDERDOUBLE21_1A_1_ADDR 13
#define MOD_NFILTER1_ALG0_STAGE2_NTHORDERDOUBLE21_1A_1_FIXPT 0x00FD39E3
#define MOD_NFILTER1_ALG0_STAGE2_NTHORDERDOUBLE21_1A_1_VALUE SIGMASTUDIOTYPE_FIXPOINT_CONVERT(1.97832917926912)
#define MOD_NFILTER1_ALG0_STAGE2_NTHORDERDOUBLE21_1A_1_TYPE SIGMASTUDIOTYPE_FIXPOINT
#define MOD_NFILTER1_ALG0_STAGE2_NTHORDERDOUBLE21_2A_1_ADDR 14
#define MOD_NFILTER1_ALG0_STAGE2_NTHORDERDOUBLE21_2A_1_FIXPT 0xFF82C19D
#define MOD_NFILTER1_ALG0_STAGE2_NTHORDERDOUBLE21_2A_1_VALUE SIGMASTUDIOTYPE_FIXPOINT_CONVERT(-0.978466474659933)
#define MOD_NFILTER1_ALG0_STAGE2_NTHORDERDOUBLE21_2A_1_TYPE SIGMASTUDIOTYPE_FIXPOINT
#define MOD_NFILTER1_ALG0_STAGE2_NTHORDERDOUBLE21_0B_2_ADDR 15
#define MOD_NFILTER1_ALG0_STAGE2_NTHORDERDOUBLE21_0B_2_FIXPT 0x007F6BCD
#define MOD_NFILTER1_ALG0_STAGE2_NTHORDERDOUBLE21_0B_2_VALUE SIGMASTUDIOTYPE_FIXPOINT_CONVERT(0.995477412968606)
#define MOD_NFILTER1_ALG0_STAGE2_NTHORDERDOUBLE21_0B_2_TYPE SIGMASTUDIOTYPE_FIXPOINT
#define MOD_NFILTER1_ALG0_STAGE2_NTHORDERDOUBLE21_1B_2_ADDR 16
#define MOD_NFILTER1_ALG0_STAGE2_NTHORDERDOUBLE21_1B_2_FIXPT 0xFF012865
#define MOD_NFILTER1_ALG0_STAGE2_NTHORDERDOUBLE21_1B_2_VALUE SIGMASTUDIOTYPE_FIXPOINT_CONVERT(-1.99095482593721)
#define MOD_NFILTER1_ALG0_STAGE2_NTHORDERDOUBLE21_1B_2_TYPE SIGMASTUDIOTYPE_FIXPOINT
#define MOD_NFILTER1_ALG0_STAGE2_NTHORDERDOUBLE21_2B_2_ADDR 17
#define MOD_NFILTER1_ALG0_STAGE2_NTHORDERDOUBLE21_2B_2_FIXPT 0x007F6BCD
#define MOD_NFILTER1_ALG0_STAGE2_NTHORDERDOUBLE21_2B_2_VALUE SIGMASTUDIOTYPE_FIXPOINT_CONVERT(0.995477412968606)
#define MOD_NFILTER1_ALG0_STAGE2_NTHORDERDOUBLE21_2B_2_TYPE SIGMASTUDIOTYPE_FIXPOINT
#define MOD_NFILTER1_ALG0_STAGE2_NTHORDERDOUBLE21_1A_2_ADDR 18
#define MOD_NFILTER1_ALG0_STAGE2_NTHORDERDOUBLE21_1A_2_FIXPT 0x00FED558
#define MOD_NFILTER1_ALG0_STAGE2_NTHORDERDOUBLE21_1A_2_VALUE SIGMASTUDIOTYPE_FIXPOINT_CONVERT(1.99088574253114)
#define MOD_NFILTER1_ALG0_STAGE2_NTHORDERDOUBLE21_1A_2_TYPE SIGMASTUDIOTYPE_FIXPOINT
#define MOD_NFILTER1_ALG0_STAGE2_NTHORDERDOUBLE21_2A_2_ADDR 19
#define MOD_NFILTER1_ALG0_STAGE2_NTHORDERDOUBLE21_2A_2_FIXPT 0xFF812621
#define MOD_NFILTER1_ALG0_STAGE2_NTHORDERDOUBLE21_2A_2_VALUE SIGMASTUDIOTYPE_FIXPOINT_CONVERT(-0.991023909343287)
#define MOD_NFILTER1_ALG0_STAGE2_NTHORDERDOUBLE21_2A_2_TYPE SIGMASTUDIOTYPE_FIXPOINT

/* Module Gain1 - Gain*/
#define MOD_GAIN1_COUNT                                1
#define MOD_GAIN1_DEVICE                               "IC1"
#define MOD_GAIN1_GAIN1940ALGNS1_ADDR                  20
#define MOD_GAIN1_GAIN1940ALGNS1_FIXPT                 0x00400000
#define MOD_GAIN1_GAIN1940ALGNS1_VALUE                 SIGMASTUDIOTYPE_FIXPOINT_CONVERT(0.5)
#define MOD_GAIN1_GAIN1940ALGNS1_TYPE                  SIGMASTUDIOTYPE_FIXPOINT

/* Module NFilter2 - Nth Order Filter*/
#define MOD_NFILTER2_COUNT                             10
#define MOD_NFILTER2_DEVICE                            "IC1"
#define MOD_NFILTER2_ALG0_STAGE2_NTHORDERDOUBLE1_0B_1_ADDR 21
#define MOD_NFILTER2_ALG0_STAGE2_NTHORDERDOUBLE1_0B_1_FIXPT 0x0000057B
#define MOD_NFILTER2_ALG0_STAGE2_NTHORDERDOUBLE1_0B_1_VALUE SIGMASTUDIOTYPE_FIXPOINT_CONVERT(0.000167291672404979)
#define MOD_NFILTER2_ALG0_STAGE2_NTHORDERDOUBLE1_0B_1_TYPE SIGMASTUDIOTYPE_FIXPOINT
#define MOD_NFILTER2_ALG0_STAGE2_NTHORDERDOUBLE1_1B_1_ADDR 22
#define MOD_NFILTER2_ALG0_STAGE2_NTHORDERDOUBLE1_1B_1_FIXPT 0x00000AF6
#define MOD_NFILTER2_ALG0_STAGE2_NTHORDERDOUBLE1_1B_1_VALUE SIGMASTUDIOTYPE_FIXPOINT_CONVERT(0.000334583344809959)
#define MOD_NFILTER2_ALG0_STAGE2_NTHORDERDOUBLE1_1B_1_TYPE SIGMASTUDIOTYPE_FIXPOINT
#define MOD_NFILTER2_ALG0_STAGE2_NTHORDERDOUBLE1_2B_1_ADDR 23
#define MOD_NFILTER2_ALG0_STAGE2_NTHORDERDOUBLE1_2B_1_FIXPT 0x0000057B
#define MOD_NFILTER2_ALG0_STAGE2_NTHORDERDOUBLE1_2B_1_VALUE SIGMASTUDIOTYPE_FIXPOINT_CONVERT(0.000167291672404979)
#define MOD_NFILTER2_ALG0_STAGE2_NTHORDERDOUBLE1_2B_1_TYPE SIGMASTUDIOTYPE_FIXPOINT
#define MOD_NFILTER2_ALG0_STAGE2_NTHORDERDOUBLE1_1A_1_ADDR 24
#define MOD_NFILTER2_ALG0_STAGE2_NTHORDERDOUBLE1_1A_1_FIXPT 0x00F9DE8D
#define MOD_NFILTER2_ALG0_STAGE2_NTHORDERDOUBLE1_1A_1_VALUE SIGMASTUDIOTYPE_FIXPOINT_CONVERT(1.95210428304795)
#define MOD_NFILTER2_ALG0_STAGE2_NTHORDERDOUBLE1_1A_1_TYPE SIGMASTUDIOTYPE_FIXPOINT
#define MOD_NFILTER2_ALG0_STAGE2_NTHORDERDOUBLE1_2A_1_ADDR 25
#define MOD_NFILTER2_ALG0_STAGE2_NTHORDERDOUBLE1_2A_1_FIXPT 0xFF860B86
#define MOD_NFILTER2_ALG0_STAGE2_NTHORDERDOUBLE1_2A_1_VALUE SIGMASTUDIOTYPE_FIXPOINT_CONVERT(-0.952773449737573)
#define MOD_NFILTER2_ALG0_STAGE2_NTHORDERDOUBLE1_2A_1_TYPE SIGMASTUDIOTYPE_FIXPOINT
#define MOD_NFILTER2_ALG0_STAGE2_NTHORDERDOUBLE1_0B_2_ADDR 26
#define MOD_NFILTER2_ALG0_STAGE2_NTHORDERDOUBLE1_0B_2_FIXPT 0x0000058F
#define MOD_NFILTER2_ALG0_STAGE2_NTHORDERDOUBLE1_0B_2_VALUE SIGMASTUDIOTYPE_FIXPOINT_CONVERT(0.000169638164549707)
#define MOD_NFILTER2_ALG0_STAGE2_NTHORDERDOUBLE1_0B_2_TYPE SIGMASTUDIOTYPE_FIXPOINT
#define MOD_NFILTER2_ALG0_STAGE2_NTHORDERDOUBLE1_1B_2_ADDR 27
#define MOD_NFILTER2_ALG0_STAGE2_NTHORDERDOUBLE1_1B_2_FIXPT 0x00000B1E
#define MOD_NFILTER2_ALG0_STAGE2_NTHORDERDOUBLE1_1B_2_VALUE SIGMASTUDIOTYPE_FIXPOINT_CONVERT(0.000339276329099415)
#define MOD_NFILTER2_ALG0_STAGE2_NTHORDERDOUBLE1_1B_2_TYPE SIGMASTUDIOTYPE_FIXPOINT
#define MOD_NFILTER2_ALG0_STAGE2_NTHORDERDOUBLE1_2B_2_ADDR 28
#define MOD_NFILTER2_ALG0_STAGE2_NTHORDERDOUBLE1_2B_2_FIXPT 0x0000058F
#define MOD_NFILTER2_ALG0_STAGE2_NTHORDERDOUBLE1_2B_2_VALUE SIGMASTUDIOTYPE_FIXPOINT_CONVERT(0.000169638164549707)
#define MOD_NFILTER2_ALG0_STAGE2_NTHORDERDOUBLE1_2B_2_TYPE SIGMASTUDIOTYPE_FIXPOINT
#define MOD_NFILTER2_ALG0_STAGE2_NTHORDERDOUBLE1_1A_2_ADDR 29
#define MOD_NFILTER2_ALG0_STAGE2_NTHORDERDOUBLE1_1A_2_FIXPT 0x00FD5FC5
#define MOD_NFILTER2_ALG0_STAGE2_NTHORDERDOUBLE1_1A_2_VALUE SIGMASTUDIOTYPE_FIXPOINT_CONVERT(1.97948518790718)
#define MOD_NFILTER2_ALG0_STAGE2_NTHORDERDOUBLE1_1A_2_TYPE SIGMASTUDIOTYPE_FIXPOINT
#define MOD_NFILTER2_ALG0_STAGE2_NTHORDERDOUBLE1_2A_2_ADDR 30
#define MOD_NFILTER2_ALG0_STAGE2_NTHORDERDOUBLE1_2A_2_FIXPT 0xFF8289FF
#define MOD_NFILTER2_ALG0_STAGE2_NTHORDERDOUBLE1_2A_2_VALUE SIGMASTUDIOTYPE_FIXPOINT_CONVERT(-0.980163740565381)
#define MOD_NFILTER2_ALG0_STAGE2_NTHORDERDOUBLE1_2A_2_TYPE SIGMASTUDIOTYPE_FIXPOINT

/* Module NFilter3 - Nth Order Filter*/
#define MOD_NFILTER3_COUNT                             15
#define MOD_NFILTER3_DEVICE                            "IC1"
#define MOD_NFILTER3_ALG0_STAGE3_NTHORDERDOUBLE2_0B_1_ADDR 31
#define MOD_NFILTER3_ALG0_STAGE3_NTHORDERDOUBLE2_0B_1_FIXPT 0x007FAD4A
#define MOD_NFILTER3_ALG0_STAGE3_NTHORDERDOUBLE2_0B_1_VALUE SIGMASTUDIOTYPE_FIXPOINT_CONVERT(0.997475884462384)
#define MOD_NFILTER3_ALG0_STAGE3_NTHORDERDOUBLE2_0B_1_TYPE SIGMASTUDIOTYPE_FIXPOINT
#define MOD_NFILTER3_ALG0_STAGE3_NTHORDERDOUBLE2_1B_1_ADDR 32
#define MOD_NFILTER3_ALG0_STAGE3_NTHORDERDOUBLE2_1B_1_FIXPT 0xFF00A56C
#define MOD_NFILTER3_ALG0_STAGE3_NTHORDERDOUBLE2_1B_1_VALUE SIGMASTUDIOTYPE_FIXPOINT_CONVERT(-1.99495176892477)
#define MOD_NFILTER3_ALG0_STAGE3_NTHORDERDOUBLE2_1B_1_TYPE SIGMASTUDIOTYPE_FIXPOINT
#define MOD_NFILTER3_ALG0_STAGE3_NTHORDERDOUBLE2_2B_1_ADDR 33
#define MOD_NFILTER3_ALG0_STAGE3_NTHORDERDOUBLE2_2B_1_FIXPT 0x007FAD4A
#define MOD_NFILTER3_ALG0_STAGE3_NTHORDERDOUBLE2_2B_1_VALUE SIGMASTUDIOTYPE_FIXPOINT_CONVERT(0.997475884462384)
#define MOD_NFILTER3_ALG0_STAGE3_NTHORDERDOUBLE2_2B_1_TYPE SIGMASTUDIOTYPE_FIXPOINT
#define MOD_NFILTER3_ALG0_STAGE3_NTHORDERDOUBLE2_1A_1_ADDR 34
#define MOD_NFILTER3_ALG0_STAGE3_NTHORDERDOUBLE2_1A_1_FIXPT 0x00FF5A77
#define MOD_NFILTER3_ALG0_STAGE3_NTHORDERDOUBLE2_1A_1_VALUE SIGMASTUDIOTYPE_FIXPOINT_CONVERT(1.9949483506249)
#define MOD_NFILTER3_ALG0_STAGE3_NTHORDERDOUBLE2_1A_1_TYPE SIGMASTUDIOTYPE_FIXPOINT
#define MOD_NFILTER3_ALG0_STAGE3_NTHORDERDOUBLE2_2A_1_ADDR 35
#define MOD_NFILTER3_ALG0_STAGE3_NTHORDERDOUBLE2_2A_1_FIXPT 0xFF80A54F
#define MOD_NFILTER3_ALG0_STAGE3_NTHORDERDOUBLE2_2A_1_VALUE SIGMASTUDIOTYPE_FIXPOINT_CONVERT(-0.994955187224637)
#define MOD_NFILTER3_ALG0_STAGE3_NTHORDERDOUBLE2_2A_1_TYPE SIGMASTUDIOTYPE_FIXPOINT
#define MOD_NFILTER3_ALG0_STAGE3_NTHORDERDOUBLE2_0B_2_ADDR 36
#define MOD_NFILTER3_ALG0_STAGE3_NTHORDERDOUBLE2_0B_2_FIXPT 0x007FC365
#define MOD_NFILTER3_ALG0_STAGE3_NTHORDERDOUBLE2_0B_2_VALUE SIGMASTUDIOTYPE_FIXPOINT_CONVERT(0.998150511190452)
#define MOD_NFILTER3_ALG0_STAGE3_NTHORDERDOUBLE2_0B_2_TYPE SIGMASTUDIOTYPE_FIXPOINT
#define MOD_NFILTER3_ALG0_STAGE3_NTHORDERDOUBLE2_1B_2_ADDR 37
#define MOD_NFILTER3_ALG0_STAGE3_NTHORDERDOUBLE2_1B_2_FIXPT 0xFF007936
#define MOD_NFILTER3_ALG0_STAGE3_NTHORDERDOUBLE2_1B_2_VALUE SIGMASTUDIOTYPE_FIXPOINT_CONVERT(-1.9963010223809)
#define MOD_NFILTER3_ALG0_STAGE3_NTHORDERDOUBLE2_1B_2_TYPE SIGMASTUDIOTYPE_FIXPOINT
#define MOD_NFILTER3_ALG0_STAGE3_NTHORDERDOUBLE2_2B_2_ADDR 38
#define MOD_NFILTER3_ALG0_STAGE3_NTHORDERDOUBLE2_2B_2_FIXPT 0x007FC365
#define MOD_NFILTER3_ALG0_STAGE3_NTHORDERDOUBLE2_2B_2_VALUE SIGMASTUDIOTYPE_FIXPOINT_CONVERT(0.998150511190452)
#define MOD_NFILTER3_ALG0_STAGE3_NTHORDERDOUBLE2_2B_2_TYPE SIGMASTUDIOTYPE_FIXPOINT
#define MOD_NFILTER3_ALG0_STAGE3_NTHORDERDOUBLE2_1A_2_ADDR 39
#define MOD_NFILTER3_ALG0_STAGE3_NTHORDERDOUBLE2_1A_2_FIXPT 0x00FF86AE
#define MOD_NFILTER3_ALG0_STAGE3_NTHORDERDOUBLE2_1A_2_VALUE SIGMASTUDIOTYPE_FIXPOINT_CONVERT(1.99629760176912)
#define MOD_NFILTER3_ALG0_STAGE3_NTHORDERDOUBLE2_1A_2_TYPE SIGMASTUDIOTYPE_FIXPOINT
#define MOD_NFILTER3_ALG0_STAGE3_NTHORDERDOUBLE2_2A_2_ADDR 40
#define MOD_NFILTER3_ALG0_STAGE3_NTHORDERDOUBLE2_2A_2_FIXPT 0xFF807919
#define MOD_NFILTER3_ALG0_STAGE3_NTHORDERDOUBLE2_2A_2_VALUE SIGMASTUDIOTYPE_FIXPOINT_CONVERT(-0.996304442992686)
#define MOD_NFILTER3_ALG0_STAGE3_NTHORDERDOUBLE2_2A_2_TYPE SIGMASTUDIOTYPE_FIXPOINT
#define MOD_NFILTER3_ALG0_STAGE3_NTHORDERDOUBLE2_0B_3_ADDR 41
#define MOD_NFILTER3_ALG0_STAGE3_NTHORDERDOUBLE2_0B_3_FIXPT 0x007FE9C1
#define MOD_NFILTER3_ALG0_STAGE3_NTHORDERDOUBLE2_0B_3_VALUE SIGMASTUDIOTYPE_FIXPOINT_CONVERT(0.999321160598432)
#define MOD_NFILTER3_ALG0_STAGE3_NTHORDERDOUBLE2_0B_3_TYPE SIGMASTUDIOTYPE_FIXPOINT
#define MOD_NFILTER3_ALG0_STAGE3_NTHORDERDOUBLE2_1B_3_ADDR 42
#define MOD_NFILTER3_ALG0_STAGE3_NTHORDERDOUBLE2_1B_3_FIXPT 0xFF002C7E
#define MOD_NFILTER3_ALG0_STAGE3_NTHORDERDOUBLE2_1B_3_VALUE SIGMASTUDIOTYPE_FIXPOINT_CONVERT(-1.99864232119686)
#define MOD_NFILTER3_ALG0_STAGE3_NTHORDERDOUBLE2_1B_3_TYPE SIGMASTUDIOTYPE_FIXPOINT
#define MOD_NFILTER3_ALG0_STAGE3_NTHORDERDOUBLE2_2B_3_ADDR 43
#define MOD_NFILTER3_ALG0_STAGE3_NTHORDERDOUBLE2_2B_3_FIXPT 0x007FE9C1
#define MOD_NFILTER3_ALG0_STAGE3_NTHORDERDOUBLE2_2B_3_VALUE SIGMASTUDIOTYPE_FIXPOINT_CONVERT(0.999321160598432)
#define MOD_NFILTER3_ALG0_STAGE3_NTHORDERDOUBLE2_2B_3_TYPE SIGMASTUDIOTYPE_FIXPOINT
#define MOD_NFILTER3_ALG0_STAGE3_NTHORDERDOUBLE2_1A_3_ADDR 44
#define MOD_NFILTER3_ALG0_STAGE3_NTHORDERDOUBLE2_1A_3_FIXPT 0x00FFD366
#define MOD_NFILTER3_ALG0_STAGE3_NTHORDERDOUBLE2_1A_3_VALUE SIGMASTUDIOTYPE_FIXPOINT_CONVERT(1.99863889657332)
#define MOD_NFILTER3_ALG0_STAGE3_NTHORDERDOUBLE2_1A_3_TYPE SIGMASTUDIOTYPE_FIXPOINT
#define MOD_NFILTER3_ALG0_STAGE3_NTHORDERDOUBLE2_2A_3_ADDR 45
#define MOD_NFILTER3_ALG0_STAGE3_NTHORDERDOUBLE2_2A_3_FIXPT 0xFF802C61
#define MOD_NFILTER3_ALG0_STAGE3_NTHORDERDOUBLE2_2A_3_VALUE SIGMASTUDIOTYPE_FIXPOINT_CONVERT(-0.998645745820402)
#define MOD_NFILTER3_ALG0_STAGE3_NTHORDERDOUBLE2_2A_3_TYPE SIGMASTUDIOTYPE_FIXPOINT

/* Module Mid EQ1 - Medium Size Eq*/
#define MOD_MIDEQ1_COUNT                               5
#define MOD_MIDEQ1_DEVICE                              "IC1"
#define MOD_MIDEQ1_ALG0_STAGE0_B0_ADDR                 46
#define MOD_MIDEQ1_ALG0_STAGE0_B0_FIXPT                0x0080236C
#define MOD_MIDEQ1_ALG0_STAGE0_B0_VALUE                SIGMASTUDIOTYPE_FIXPOINT_CONVERT(1.00108099384233)
#define MOD_MIDEQ1_ALG0_STAGE0_B0_TYPE                 SIGMASTUDIOTYPE_FIXPOINT
#define MOD_MIDEQ1_ALG0_STAGE0_B1_ADDR                 47
#define MOD_MIDEQ1_ALG0_STAGE0_B1_FIXPT                0xFF005B1E
#define MOD_MIDEQ1_ALG0_STAGE0_B1_VALUE                SIGMASTUDIOTYPE_FIXPOINT_CONVERT(-1.99721942975073)
#define MOD_MIDEQ1_ALG0_STAGE0_B1_TYPE                 SIGMASTUDIOTYPE_FIXPOINT
#define MOD_MIDEQ1_ALG0_STAGE0_B2_ADDR                 48
#define MOD_MIDEQ1_ALG0_STAGE0_B2_FIXPT                0x007F81DC
#define MOD_MIDEQ1_ALG0_STAGE0_B2_VALUE                SIGMASTUDIOTYPE_FIXPOINT_CONVERT(0.996150607149333)
#define MOD_MIDEQ1_ALG0_STAGE0_B2_TYPE                 SIGMASTUDIOTYPE_FIXPOINT
#define MOD_MIDEQ1_ALG0_STAGE0_A0_ADDR                 49
#define MOD_MIDEQ1_ALG0_STAGE0_A0_FIXPT                0x00FFA505
#define MOD_MIDEQ1_ALG0_STAGE0_A0_VALUE                SIGMASTUDIOTYPE_FIXPOINT_CONVERT(1.99722359092903)
#define MOD_MIDEQ1_ALG0_STAGE0_A0_TYPE                 SIGMASTUDIOTYPE_FIXPOINT
#define MOD_MIDEQ1_ALG0_STAGE0_A1_ADDR                 50
#define MOD_MIDEQ1_ALG0_STAGE0_A1_FIXPT                0xFF805ADA
#define MOD_MIDEQ1_ALG0_STAGE0_A1_VALUE                SIGMASTUDIOTYPE_FIXPOINT_CONVERT(-0.99722743981336)
#define MOD_MIDEQ1_ALG0_STAGE0_A1_TYPE                 SIGMASTUDIOTYPE_FIXPOINT

#endif
